/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ipv6;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Component;
import java.awt.Event;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class IPv4v6Input
extends TextField
implements KeyListener,
JDMInput,
FocusListener {
    private static final int DEFAULT_WIDTH = 25;
    private static final int DEFAULT_LENGTH = 1024;
    private static final String DEFAULT_VALUE = "";
    protected int maxlength = Integer.MAX_VALUE;
    private static ResourceBundle myResources = null;
    protected boolean ignoreValue;
    protected boolean hasErrorValue;
    protected String value = "";
    private String startFD;
    private String errorFD = "";
    protected boolean haveFocus = false;
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public IPv4v6Input(String string, int n, int n2) {
        super(string, n2);
        this.maxlength = n;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.ignoreValue = false;
        this.hasErrorValue = false;
        this.setForeground(JmaColors.textText);
        ((Component)this).setBackground(JmaColors.background);
    }

    public IPv4v6Input(String string, int n) {
        this(string, 1024, n);
    }

    public IPv4v6Input(String string) {
        this(string, 1024, 25);
    }

    public IPv4v6Input() {
        this(DEFAULT_VALUE, 1024, 25);
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    public boolean isValidValue() {
        return this.isValidValue(this.value);
    }

    protected boolean isValidValue(String string) {
        if (this.ignoreValue) {
            return true;
        }
        if (this.hasErrorValue) {
            return false;
        }
        return this.value.length() == 8 || this.value.length() == 32;
    }

    protected boolean isValidValue(char c) {
        return true;
    }

    protected boolean isValidValue(int n) {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        int n4 = this.getText().length();
        int n5 = n4 - (n3 - n2) + 1;
        return n5 <= this.maxlength;
    }

    protected boolean isValidValue(Event event) {
        return true;
    }

    public String stringValue() {
        return this.getText();
    }

    public void setMaxLength(int n) {
        this.maxlength = n;
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!(c < ' ' || this.isValidValue(c) && this.isValidValue((int)c))) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.haveFocus = true;
        this.focusGained();
    }

    public void focusGained() {
        if (this.ignoreValue) {
            this.startFD = this.getText();
            ((TextComponent)this).setText(DEFAULT_VALUE);
        }
        if (this.hasErrorValue) {
            this.startFD = this.getText();
            ((TextComponent)this).setText(this.errorFD);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.ignoreValue) {
            String string = this.getText();
            if (string.equals(DEFAULT_VALUE)) {
                ((TextComponent)this).setText(this.startFD);
            } else {
                this.convert(this.getText());
            }
        } else if (this.hasErrorValue) {
            this.getText();
            this.convert(this.getText());
        } else {
            this.convert(this.getText());
        }
        this.haveFocus = false;
    }

    public String toString() {
        return String.valueOf(this.getValue().toString()) + " : " + this.getText().toString();
    }

    public String IPValue() {
        if (this.isValidValue()) {
            return this.value;
        }
        return DEFAULT_VALUE;
    }

    public Object getValue() {
        String string = this.IPValue();
        if (string == DEFAULT_VALUE) {
            return null;
        }
        return new OctetString(this.value);
    }

    public void setValue(String string) {
        ((TextComponent)this).setText(string);
        if (string.equals(" ")) {
            this.ignoreValue = true;
            this.hasErrorValue = false;
            this.value = "00";
            return;
        }
        this.ignoreValue = false;
        this.hasErrorValue = !this.convert(string);
        if (this.haveFocus) {
            this.focusGained();
        }
    }

    public void setValue(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            if (octetString.value.length == 4) {
                ((TextComponent)this).setText(this.toIPv4(octetString.value));
            } else if (octetString.value.length == 16) {
                ((TextComponent)this).setText(this.toIPv6(octetString.toString(), octetString.value));
            } else {
                ((TextComponent)this).setText(octetString.toString());
            }
            this.ignoreValue = false;
            this.hasErrorValue = false;
            this.value = octetString.toString();
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            ((TextComponent)this).setText(specialValue.toString());
            this.ignoreValue = object instanceof NotSupported;
            this.hasErrorValue = true;
            return;
        }
        if (object instanceof String) {
            this.setValue((String)object);
            return;
        }
        ((TextComponent)this).setText(object.toString());
        this.hasErrorValue = true;
        this.ignoreValue = true;
    }

    private String toIPv4(byte[] byArray) {
        IPAddress iPAddress = new IPAddress(byArray, 0);
        return iPAddress.getIpAddress();
    }

    private String toIPv6(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string.length() != 32) {
            return string;
        }
        if (string.equals("00000000000000000000000000000000")) {
            return "::";
        }
        if (string.equals("00000000000000000000000000000001")) {
            return "::1";
        }
        int n2 = 0;
        while (n2 < 32) {
            String string2 = string.substring(n2, n2 + 4);
            if (string2.equals("0000")) {
                ++n;
                if (!bl2) {
                    stringBuffer.append("0");
                }
                if (n == 6 && n2 == 20) {
                    bl = true;
                }
            } else {
                if (n == 1) {
                    stringBuffer.append("0:");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                    bl2 = false;
                    if (bl3) {
                        stringBuffer.append(":");
                    }
                }
                string2 = this.zeroStrip(string2);
                stringBuffer.append(string2);
                if (n == 5 && n2 == 20 && (string2.equals("ffff") || string2.equals("FFFF"))) {
                    bl = true;
                }
                n = 0;
                bl3 = false;
            }
            if (n2 == 28) {
                if (n == 1) {
                    stringBuffer.append("0");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                }
                if (n == 8) {
                    stringBuffer.append(":");
                }
            } else if (n == 0) {
                stringBuffer.append(":");
            }
            if (bl) {
                if (n > 4) {
                    stringBuffer.append(":");
                }
                if (n == 6) {
                    stringBuffer.append(":");
                }
                IPAddress iPAddress = new IPAddress(byArray, 12);
                stringBuffer.append(iPAddress.getIpAddress());
                break;
            }
            n2 += 4;
        }
        return stringBuffer.toString().toUpperCase();
    }

    private String zeroStrip(String string) {
        String string2 = string;
        if (string2 != null && string2.trim() != null) {
            int n = 0;
            while (n < string.length()) {
                if (string2.startsWith("0")) {
                    string2 = string2.substring(1);
                }
                ++n;
            }
        }
        return string2;
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.EuiErrorResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean convert(String string) {
        if (string.length() == 0) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            if (string != null) {
                StringBuffer stringBuffer2 = new StringBuffer(5);
                int n = 0;
                String string2 = new String("0000");
                boolean bl4 = true;
                boolean bl5 = false;
                StringBuffer stringBuffer3 = new StringBuffer(32);
                StringBuffer stringBuffer4 = new StringBuffer(32);
                StringBuffer stringBuffer5 = new StringBuffer(32);
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = new byte[4];
                int n6 = 4;
                string = string.toUpperCase();
                int n7 = 0;
                while (n7 < string.length()) {
                    String string3 = string.substring(n7, n7 + 1);
                    if (string3.equals(":")) {
                        bl = false;
                        n6 = 4;
                        ++n3;
                        if (++n2 > 7) {
                            bl3 = false;
                            break;
                        }
                        if (n3 > 2) {
                            bl3 = false;
                            break;
                        }
                        if (bl2) {
                            bl3 = false;
                            break;
                        }
                        if (bl4) {
                            stringBuffer3.append(String.valueOf(string2.substring(0, 4 - n)) + stringBuffer2.toString());
                        } else {
                            stringBuffer4.append(String.valueOf(string2.substring(0, 4 - n)) + stringBuffer2.toString());
                        }
                        stringBuffer2 = new StringBuffer(5);
                        n = 0;
                        if (n3 == 2) {
                            if (bl5) {
                                bl3 = false;
                                break;
                            }
                            bl4 = false;
                            bl5 = true;
                        }
                    } else if (string3.equals(".")) {
                        bl2 = true;
                        n6 = 3;
                        ++n4;
                        ++n5;
                        if (n > n6) {
                            bl3 = false;
                            break;
                        }
                        if (n4 > 3) {
                            bl3 = false;
                            break;
                        }
                        if (n5 > 1) {
                            bl3 = false;
                            break;
                        }
                        int n8 = Integer.parseInt(stringBuffer2.toString());
                        if (n8 > 255) {
                            bl3 = false;
                            break;
                        }
                        byArray[n4 - 1] = (byte)n8;
                        stringBuffer2 = new StringBuffer(5);
                        n = 0;
                    } else {
                        n3 = 0;
                        n5 = 0;
                        stringBuffer2.append(string3);
                        if (++n > n6) {
                            bl3 = false;
                            break;
                        }
                        if (bl2 && !Character.isDigit(string3.charAt(0))) {
                            bl3 = false;
                            break;
                        }
                        if (!IPv4v6Input.isHex(string3.charAt(0))) {
                            bl3 = false;
                            break;
                        }
                    }
                    ++n7;
                }
                if (bl3) {
                    if (bl2) {
                        int n9;
                        ++n5;
                        ++n2;
                        if (++n4 != 4) {
                            bl3 = false;
                        }
                        if (n5 > 1) {
                            bl3 = false;
                        }
                        if ((n9 = Integer.parseInt(stringBuffer2.toString())) > 255) {
                            bl3 = false;
                        } else {
                            byArray[3] = (byte)n9;
                        }
                        if (bl3) {
                            stringBuffer4.append(IPv4v6Input.myHex(byArray));
                        }
                    } else if (bl4) {
                        stringBuffer3.append(String.valueOf(string2.substring(0, 4 - n)) + stringBuffer2.toString());
                    } else {
                        stringBuffer4.append(String.valueOf(string2.substring(0, 4 - n)) + stringBuffer2.toString());
                    }
                    stringBuffer.append(stringBuffer3.toString());
                    if (bl5) {
                        int n10 = 0;
                        while (n10 < 7 - n2) {
                            stringBuffer5.append(string2);
                            ++n10;
                        }
                        stringBuffer.append(stringBuffer5.toString());
                    }
                    stringBuffer.append(stringBuffer4.toString());
                }
                if (bl) {
                    if (stringBuffer.length() != 8) {
                        bl3 = false;
                    }
                } else if (stringBuffer.length() != 32) {
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        }
        catch (Exception exception) {
            bl3 = false;
        }
        if (bl3) {
            this.hasErrorValue = false;
            this.ignoreValue = false;
            this.value = stringBuffer.toString();
            this.errorFD = DEFAULT_VALUE;
        } else {
            this.hasErrorValue = true;
            this.ignoreValue = false;
            ((TextComponent)this).setText(IPv4v6Input.messageText("valueOutOfRange"));
            this.errorFD = string;
            this.value = "00";
        }
        return bl3;
    }

    public static String myHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] >> 4 & 0xF;
            int n3 = byArray[n] & 0xF;
            stringBuffer.append(hexchars[n2]);
            stringBuffer.append(hexchars[n3]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isHex(char c) {
        int n = 0;
        while (n < 16) {
            if (c == hexchars[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

